/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.Block0Descriptor;
import com.quantumdata.edideditor.CVT3ByteCodeDescriptor;
import com.quantumdata.edideditor.ColorManagementData;
import com.quantumdata.edideditor.ColorPointDescriptor;
import com.quantumdata.edideditor.DummyDescriptor;
import com.quantumdata.edideditor.EstablishedTimingsIIIDescriptor;
import com.quantumdata.edideditor.MonitorASCIIData;
import com.quantumdata.edideditor.MonitorManufacturer;
import com.quantumdata.edideditor.MonitorName;
import com.quantumdata.edideditor.MonitorRangeLimits;
import com.quantumdata.edideditor.MonitorSTI;
import com.quantumdata.edideditor.MonitorSerialNumber;
import com.quantumdata.edideditor.STI;
import com.quantumdata.edideditor.TimingDescriptor;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Block0 {
    private int[] block0_Header = new int[8];
    private char[] block0_ManufactureName = new char[3];
    private int[] block0_ProdCode = new int[2];
    private String block0_SerialNum;
    private int block0_WeekManufacture;
    private int block0_YearManufacture;
    private int block0_Version;
    private int block0_Revision;
    private int block0_VideoInputDefinition;
    private int block0_HorizontalScreenSizeOrARL;
    private int block0_VerticalScreenSizeOrARP;
    private double block0_Gamma;
    private double chromaticity_red_x;
    private double chromaticity_red_y;
    private double chromaticity_green_x;
    private double chromaticity_green_y;
    private double chromaticity_blue_x;
    private double chromaticity_blue_y;
    private double chromaticity_white_x;
    private double chromaticity_white_y;
    private int feature_support_standby;
    private int feature_support_suspend;
    private int feature_support_active_off;
    private int feature_support_display_type;
    private int feature_support_standard_color_space;
    private int feature_support_preferred_timing_mode;
    private int feature_support_default_gtf;
    private int block0_Established_Timings_One;
    private int block0_Established_Timings_Two;
    private int block0_Established_Timings_Manufacture;
    private ArrayList<STI> aSTI;
    private ArrayList<Block0Descriptor> aDescriptors;
    private int iExtensionFlag;
    private int block0_Checksum;
    private final int HORIZONTAL_REF_SIZE = 60;
    private final int VERTICAL_REF_SIZE = 45;
    private final double ARL_REF_VALUE = 1.333;
    private final double ARP_REF_VALUE = 0.75;

    public Block0() {
        this(129);
    }

    public Block0(int n) {
        this.block0_Header[0] = 0;
        this.block0_Header[1] = 255;
        this.block0_Header[2] = 255;
        this.block0_Header[3] = 255;
        this.block0_Header[4] = 255;
        this.block0_Header[5] = 255;
        this.block0_Header[6] = 255;
        this.block0_Header[7] = 0;
        this.block0_Version = 1;
        this.block0_Revision = 3;
        this.aSTI = new ArrayList(8);
        for (int i = 8; i > 0; --i) {
            this.aSTI.add(new STI());
        }
        this.aDescriptors = new ArrayList(4);
        this.iExtensionFlag = 0;
        this.block0_Checksum = 0;
    }

    public String getHeader() {
        String string = new String();
        int n = 0;
        for (n = 0; n < this.block0_Header.length; ++n) {
            string = string.concat(String.format("%02X", this.block0_Header[n]));
        }
        return string;
    }

    private int getHeaderChecksumValue() {
        int n = 0;
        int n2 = 0;
        for (n2 = 0; n2 < this.block0_Header.length; ++n2) {
            n += this.block0_Header[n2];
        }
        return n & 0xFF;
    }

    public boolean setManufacturerName(String string) {
        boolean bl = false;
        if ((string = string.toUpperCase()).length() == 3) {
            char c;
            this.block0_ManufactureName[0] = c = string.charAt(0);
            this.block0_ManufactureName[1] = c = string.charAt(1);
            this.block0_ManufactureName[2] = c = string.charAt(2);
            bl = true;
        }
        return bl;
    }

    public String getManufacturerName() {
        return new String(this.block0_ManufactureName);
    }

    public boolean setProductCode(String string) {
        boolean bl = false;
        if ((string = string.toUpperCase()).length() == 4) {
            this.block0_ProdCode[0] = Integer.parseInt(string.substring(0, 2), 16);
            this.block0_ProdCode[1] = Integer.parseInt(string.substring(2, 4), 16);
            bl = true;
        }
        return bl;
    }

    public String getProductCode() {
        String string = new String(String.format("%02X", this.block0_ProdCode[0]));
        string = string.concat(String.format("%02X", this.block0_ProdCode[1]));
        return string;
    }

    public void setSerialNum(String string) {
        String string2 = new String();
        int n = 8 - (string = string.toUpperCase()).length();
        if (n > 0) {
            while (n > 0) {
                string2 = string2.concat("0");
                --n;
            }
        }
        this.block0_SerialNum = string2 = string2.concat(string);
    }

    public String getSerialNum() {
        return this.block0_SerialNum;
    }

    public void setWeekManufacture(int n) {
        this.block0_WeekManufacture = n != 54 ? n : 255;
    }

    public int getWeekManufacture() {
        return this.block0_WeekManufacture;
    }

    public String setYearManufacture(int n) {
        String string = null;
        if (n >= 1990 & n <= 2245) {
            this.block0_YearManufacture = n;
        } else {
            string = "Year of Manufacture should be between 1990 and 2245";
        }
        return string;
    }

    public String getYearManufacture() {
        return Integer.toString(this.block0_YearManufacture);
    }

    public String getProductIdentification() {
        String string = this.convertToEISA();
        string = string.concat(this.getProductCode());
        string = string.concat(this.getSerialNum());
        string = string.concat(String.format("%02X", this.getWeekManufacture()));
        string = string.concat(String.format("%02X", Integer.parseInt(this.getYearManufacture(), 10) - 1990));
        return string;
    }

    private int getProductIdentificationChecksumValue() {
        int n = 0;
        String string = this.getProductIdentification();
        int n2 = 0;
        for (n2 = 0; n2 < string.length(); n2 += 2) {
            n += Integer.parseInt(string.substring(n2, n2 + 2), 16);
        }
        return n & 0xFF;
    }

    public String getVersion() {
        return String.format("%02X", this.block0_Version);
    }

    public void setRevision(int n) {
        this.block0_Revision = n;
    }

    public int getRevision() {
        return this.block0_Revision;
    }

    public String getEDIDStructInfo() {
        String string = String.format("%02X", Integer.valueOf(this.getVersion()));
        string = string.concat(String.format("%02X", this.getRevision()));
        return string;
    }

    private int getEDIDStructInfoChecksumValue() {
        int n = 0;
        n += this.block0_Version;
        return (n += this.block0_Revision) & 0xFF;
    }

    public void setAnalogDigital(int n) {
        this.block0_VideoInputDefinition = n == 1 ? (this.block0_VideoInputDefinition |= 0x80) : (this.block0_VideoInputDefinition &= 0x7F);
    }

    public int getAnalogDigital() {
        return this.block0_VideoInputDefinition >> 7;
    }

    public void setSignalLevelStandard(int n) {
        this.block0_VideoInputDefinition &= 0x9F;
        this.block0_VideoInputDefinition |= n << 5;
    }

    public int getSignalLevelStandard() {
        return (this.block0_VideoInputDefinition & 0x60) >> 5;
    }

    public void setSetup(int n) {
        this.block0_VideoInputDefinition &= 0xEF;
        this.block0_VideoInputDefinition |= n << 4;
    }

    public int getSetup() {
        return (this.block0_VideoInputDefinition & 0x10) >> 4;
    }

    public void setSyncInputsSupported_3(int n) {
        this.block0_VideoInputDefinition &= 0xF7;
        this.block0_VideoInputDefinition |= n << 3;
    }

    public int getSyncInputsSupported_3() {
        return (this.block0_VideoInputDefinition & 8) >> 3;
    }

    public void setSyncInputsSupported_2(int n) {
        this.block0_VideoInputDefinition &= 0xFB;
        this.block0_VideoInputDefinition |= n << 2;
    }

    public int getSyncInputsSupported_2() {
        return (this.block0_VideoInputDefinition & 4) >> 2;
    }

    public void setSyncInputsSupported_1(int n) {
        this.block0_VideoInputDefinition &= 0xFD;
        this.block0_VideoInputDefinition |= n << 1;
    }

    public int getSyncInputsSupported_1() {
        return (this.block0_VideoInputDefinition & 2) >> 1;
    }

    public void setSyncInputsSupported_0(int n) {
        this.block0_VideoInputDefinition &= 0xFE;
        this.block0_VideoInputDefinition |= n;
    }

    public int getSyncInputsSupported_0() {
        return this.block0_VideoInputDefinition & 1;
    }

    public int getSyncInputs() {
        int n = this.getSyncInputsSupported_3();
        n = n << 1 | this.getSyncInputsSupported_2();
        n = n << 1 | this.getSyncInputsSupported_1();
        n = n << 1 | this.getSyncInputsSupported_0();
        return n;
    }

    public void setDFP(int n) {
        this.block0_VideoInputDefinition &= 0xFE;
        this.block0_VideoInputDefinition |= n;
    }

    public int getDFP() {
        return this.block0_VideoInputDefinition & 1;
    }

    public void setColorBitDepth(int n) {
        this.block0_VideoInputDefinition &= 0x8F;
        this.block0_VideoInputDefinition |= n;
    }

    public int getColorBitDepth() {
        return (this.block0_VideoInputDefinition & 0x70) >> 4;
    }

    public void setDigitalVideoInterface(int n) {
        this.block0_VideoInputDefinition &= 0xF0;
        this.block0_VideoInputDefinition |= n;
    }

    public int getDigitalVideoInterface() {
        return this.block0_VideoInputDefinition & 0xF;
    }

    private void setVideoInputDefinition(String string) {
        int n = Integer.parseInt(string.substring(0, 2), 16);
        int n2 = n >> 7;
        this.setAnalogDigital(n2);
        if (n2 == 1) {
            if (this.block0_Revision == 3) {
                this.setDFP(n & 1);
            } else if (this.block0_Revision == 4) {
                this.setColorBitDepth(n & 0x70);
                this.setDigitalVideoInterface(n & 0xF);
            }
        } else {
            this.setSignalLevelStandard(n >> 5 & 3);
            this.setSetup(n >> 4 & 1);
            this.setSyncInputsSupported_3(n >> 3 & 1);
            this.setSyncInputsSupported_2(n >> 2 & 1);
            this.setSyncInputsSupported_1(n >> 1 & 1);
            this.setSyncInputsSupported_0(n & 1);
        }
    }

    public String getVideoInputDefinition() {
        return String.format("%02X", this.block0_VideoInputDefinition);
    }

    public void setMaxHorizontalImage(int n) {
        this.block0_HorizontalScreenSizeOrARL = n;
    }

    public String getHorizontalScreenSize() {
        if (this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP != 0) {
            return String.valueOf(this.block0_HorizontalScreenSizeOrARL);
        }
        if (this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP == 0) {
            double d = (double)(this.block0_HorizontalScreenSizeOrARL + 99) / 100.0;
            return String.valueOf((int)(45.0 * d));
        }
        return String.valueOf(60);
    }

    public int getHorizontalScreenSizeOrARL() {
        return this.block0_HorizontalScreenSizeOrARL;
    }

    public void setMaxVerticalImage(int n) {
        this.block0_VerticalScreenSizeOrARP = n;
    }

    public String getVerticalScreenSize() {
        if (this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP != 0) {
            return String.valueOf(this.block0_VerticalScreenSizeOrARP);
        }
        if (this.block0_HorizontalScreenSizeOrARL == 0 && this.block0_VerticalScreenSizeOrARP != 0) {
            double d = 100.0 / (double)(this.block0_VerticalScreenSizeOrARP + 99);
            return String.valueOf((int)(60.0 * d));
        }
        return String.valueOf(45);
    }

    public int getVerticalScreenSizeOrARP() {
        return this.block0_VerticalScreenSizeOrARP;
    }

    public void setAspectRatioLandscape(double d) {
        this.block0_HorizontalScreenSizeOrARL = (int)(d * 100.0 - 99.0);
    }

    public String getAspectRatioLandscape() {
        String string = this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP != 0 ? String.valueOf((double)this.block0_HorizontalScreenSizeOrARL / (double)this.block0_VerticalScreenSizeOrARP) : (this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP == 0 ? String.valueOf((double)(this.block0_HorizontalScreenSizeOrARL + 99) / 100.0) : (this.block0_HorizontalScreenSizeOrARL == 0 && this.block0_VerticalScreenSizeOrARP != 0 ? String.valueOf((double)(this.block0_VerticalScreenSizeOrARP + 99) / 100.0) : String.valueOf(1.333)));
        if (string.length() > 4) {
            return string.substring(0, 4);
        }
        return string;
    }

    public void setAspectRatioPortrait(double d) {
        this.block0_VerticalScreenSizeOrARP = (int)(100.0 / d - 99.0 > 255.0 ? 255.0 : 100.0 / d - 99.0);
    }

    public String getAspectRatioPortrait() {
        String string = this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP != 0 ? String.valueOf((double)this.block0_VerticalScreenSizeOrARP / (double)this.block0_HorizontalScreenSizeOrARL) : (this.block0_HorizontalScreenSizeOrARL != 0 && this.block0_VerticalScreenSizeOrARP == 0 ? String.valueOf(100.0 / (double)(this.block0_HorizontalScreenSizeOrARL + 99)) : (this.block0_HorizontalScreenSizeOrARL == 0 && this.block0_VerticalScreenSizeOrARP != 0 ? String.valueOf(100.0 / (double)(this.block0_VerticalScreenSizeOrARP + 99)) : String.valueOf(0.75)));
        if (string.length() > 4) {
            return string.substring(0, 4);
        }
        return string;
    }

    public void setGamma(String string) {
        this.block0_Gamma = Double.valueOf(string);
    }

    public String getGamma() {
        return Double.toString(this.block0_Gamma);
    }

    public void setFeatureSupport_Standby(int n) {
        this.feature_support_standby = n;
    }

    public int getFeatureSupport_Standby() {
        return this.feature_support_standby;
    }

    public void setFeatureSupport_Suspend(int n) {
        this.feature_support_suspend = n;
    }

    public int getFeatureSupport_Suspend() {
        return this.feature_support_suspend;
    }

    public void setFeatureSupport_ActiveOff(int n) {
        this.feature_support_active_off = n;
    }

    public int getFeatureSupport_ActiveOff() {
        return this.feature_support_active_off;
    }

    public void setFeatureSupport_DisplayType(int n) {
        this.feature_support_display_type = n;
    }

    public int getFeatureSupport_DisplayType() {
        return this.feature_support_display_type;
    }

    public void setFeatureSupport_StandardColorSpace(int n) {
        this.feature_support_standard_color_space = n;
    }

    public int getFeatureSupport_StandardColorSpace() {
        return this.feature_support_standard_color_space;
    }

    public void setFeatureSupport_PreferredTimingMode(int n) {
        this.feature_support_preferred_timing_mode = n;
    }

    public int getFeatureSupport_PreferredTimingMode() {
        return this.feature_support_preferred_timing_mode;
    }

    public void setFeatureSupport_DefaultGTF(int n) {
        this.feature_support_default_gtf = n;
    }

    public int getFeatureSupport_DefaultGTF() {
        return this.feature_support_default_gtf;
    }

    private void setFeatureSupport(String string) {
        int n = Integer.parseInt(string, 16);
        this.feature_support_default_gtf = n & 1;
        this.feature_support_preferred_timing_mode = (n & 2) >> 1;
        this.feature_support_standard_color_space = (n & 4) >> 2;
        this.feature_support_display_type = (n & 0x18) >> 3;
        this.feature_support_active_off = (n & 0x20) >> 5;
        this.feature_support_suspend = (n & 0x40) >> 6;
        this.feature_support_standby = (n & 0x80) >> 7;
    }

    private String getFeatureSupport() {
        int n = 0;
        n |= this.feature_support_standby << 7;
        n |= this.feature_support_suspend << 6;
        n |= this.feature_support_active_off << 5;
        n |= this.feature_support_display_type << 3;
        n |= this.feature_support_standard_color_space << 2;
        n |= this.feature_support_preferred_timing_mode << 1;
        return String.format("%02X", n |= this.feature_support_default_gtf);
    }

    public String getBasicDisplayInfo() {
        String string = new String();
        string = string.concat(this.getVideoInputDefinition());
        string = string.concat(String.format("%02X", this.getHorizontalScreenSizeOrARL()));
        string = string.concat(String.format("%02X", this.getVerticalScreenSizeOrARP()));
        int n = (int)(this.block0_Gamma * 100.0 - 100.0);
        string = string.concat(String.format("%02X", n));
        string = string.concat(this.getFeatureSupport().toUpperCase());
        return string;
    }

    private int getBasicDisplayChecksumValue() {
        int n = 0;
        String string = this.getBasicDisplayInfo();
        for (int i = 0; i < string.length(); i += 2) {
            n += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n & 0xFF;
    }

    public void setChromaticity_Red_x(String string) {
        this.chromaticity_red_x = Double.valueOf(string);
    }

    public String getChromaticity_Red_x() {
        String string = Double.toString(this.chromaticity_red_x);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_Red_y(String string) {
        this.chromaticity_red_y = Double.valueOf(string);
    }

    public String getChromaticity_Red_y() {
        String string = Double.toString(this.chromaticity_red_y);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_Green_x(String string) {
        this.chromaticity_green_x = Double.valueOf(string);
    }

    public String getChromaticity_Green_x() {
        String string = Double.toString(this.chromaticity_green_x);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_Green_y(String string) {
        this.chromaticity_green_y = Double.valueOf(string);
    }

    public String getChromaticity_Green_y() {
        String string = Double.toString(this.chromaticity_green_y);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_Blue_x(String string) {
        this.chromaticity_blue_x = Double.valueOf(string);
    }

    public String getChromaticity_Blue_x() {
        String string = Double.toString(this.chromaticity_blue_x);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_Blue_y(String string) {
        this.chromaticity_blue_y = Double.valueOf(string);
    }

    public String getChromaticity_Blue_y() {
        String string = Double.toString(this.chromaticity_blue_y);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_White_x(String string) {
        this.chromaticity_white_x = Double.valueOf(string);
    }

    public String getChromaticity_White_x() {
        String string = Double.toString(this.chromaticity_white_x);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity_White_y(String string) {
        this.chromaticity_white_y = Double.valueOf(string);
    }

    public String getChromaticity_White_y() {
        String string = Double.toString(this.chromaticity_white_y);
        if (string.length() > 4) {
            string = string.substring(0, 5);
        }
        return string;
    }

    public void setChromaticity(String string) {
        String string2 = new String(string.substring(0, 1));
        String string3 = new String(string.substring(1, 2));
        int n = Integer.parseInt(string2, 16) >> 2;
        int n2 = Integer.parseInt(string2, 16) & 3;
        int n3 = Integer.parseInt(string3, 16) >> 2;
        int n4 = Integer.parseInt(string3, 16) & 3;
        string2 = new String(string.substring(2, 3));
        string3 = new String(string.substring(3, 4));
        int n5 = Integer.parseInt(string2, 16) >> 2;
        int n6 = Integer.parseInt(string2, 16) & 3;
        int n7 = Integer.parseInt(string3, 16) >> 2;
        int n8 = Integer.parseInt(string3, 16) & 3;
        int n9 = Integer.parseInt(new String(string.substring(4, 6)), 16);
        int n10 = Integer.parseInt(new String(string.substring(6, 8)), 16);
        n9 = n9 << 2 | n;
        this.chromaticity_red_x = (double)Math.round((double)n9 / 1.024) / 1000.0;
        n10 = n10 << 2 | n2;
        this.chromaticity_red_y = (double)Math.round((double)n10 / 1.024) / 1000.0;
        int n11 = Integer.parseInt(new String(string.substring(8, 10)), 16);
        int n12 = Integer.parseInt(new String(string.substring(10, 12)), 16);
        n11 = n11 << 2 | n3;
        this.chromaticity_green_x = (double)Math.round((double)n11 / 1.024) / 1000.0;
        n12 = n12 << 2 | n4;
        this.chromaticity_green_y = (double)Math.round((double)n12 / 1.024) / 1000.0;
        int n13 = Integer.parseInt(new String(string.substring(12, 14)), 16);
        int n14 = Integer.parseInt(new String(string.substring(14, 16)), 16);
        n13 = n13 << 2 | n5;
        this.chromaticity_blue_x = (double)Math.round((double)n13 / 1.024) / 1000.0;
        n14 = n14 << 2 | n6;
        this.chromaticity_blue_y = (double)Math.round((double)n14 / 1.024) / 1000.0;
        int n15 = Integer.parseInt(new String(string.substring(16, 18)), 16);
        int n16 = Integer.parseInt(new String(string.substring(18, 20)), 16);
        n15 = n15 << 2 | n7;
        this.chromaticity_white_x = (double)Math.round((double)n15 / 1.024) / 1000.0;
        n16 = n16 << 2 | n8;
        this.chromaticity_white_y = (double)Math.round((double)n16 / 1.024) / 1000.0;
    }

    private int getChromaticityChecksumValue() {
        int n = 0;
        String string = this.getChromaticity();
        for (int i = 0; i < string.length(); i += 2) {
            n += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n & 0xFF;
    }

    public void setEstablishedTiming_One(int n) {
        this.block0_Established_Timings_One = n;
    }

    public int getEstablishedTiming_One() {
        return this.block0_Established_Timings_One;
    }

    public void setEstablishedTiming_Two(int n) {
        this.block0_Established_Timings_Two = n;
    }

    public int getEstablishedTiming_Two() {
        return this.block0_Established_Timings_Two;
    }

    public void setEstablishedTiming_Manufacturer(int n) {
        this.block0_Established_Timings_Manufacture = n;
    }

    public int getEstablishedTiming_Manufacturer() {
        return this.block0_Established_Timings_Manufacture;
    }

    private int getEstablishedTimingsChecksumValue() {
        int n = 0;
        String string = this.getEstablishedTimings();
        for (int i = 0; i < string.length(); i += 2) {
            n += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n & 0xFF;
    }

    public STI getSTI(int n) throws IndexOutOfBoundsException {
        return this.aSTI.get(n);
    }

    public boolean addSTI(STI sTI) {
        if (this.aSTI.size() == 8) {
            return false;
        }
        return this.aSTI.add(sTI);
    }

    private int getSTIsChecksumValue() {
        int n = 0;
        int n2 = 0;
        String string = new String();
        for (n2 = 0; n2 < this.aSTI.size(); ++n2) {
            string = string + this.aSTI.get(n2).extractSTIData();
        }
        for (n2 = 0; n2 < string.length(); n2 += 2) {
            n += Integer.parseInt(string.substring(n2, n2 + 2), 16);
        }
        return n & 0xFF;
    }

    private void reSort() {
        if (this.aDescriptors.get(0).getDescriptorType() != 0) {
            for (int i = 0; i < this.aDescriptors.size(); ++i) {
                if (this.aDescriptors.get(i).getDescriptorType() != 0) continue;
                this.swap(0, i);
                break;
            }
        }
    }

    private void swap(int n, int n2) {
        Block0Descriptor block0Descriptor = this.aDescriptors.get(n2);
        this.aDescriptors.remove(n2);
        this.aDescriptors.add(n2, this.aDescriptors.get(n));
        this.aDescriptors.set(n, block0Descriptor);
    }

    private boolean validateDescriptors() {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.aDescriptors.size(); ++i) {
            if (this.aDescriptors.get(i).getDescriptorType() == 0) {
                bl = true;
            }
            if (this.aDescriptors.get(i).getDescriptorType() != 1) continue;
            ++n;
        }
        return n >= 2 & bl;
    }

    public int getFirstMonitorDescIndex() {
        int n;
        if (this.aDescriptors.size() >= 4) {
            return -1;
        }
        for (n = 0; n < this.aDescriptors.size(); ++n) {
            if (this.aDescriptors.get(n).getDescriptorType() == 0) continue;
            return n;
        }
        return n;
    }

    public boolean addDescriptor(Block0Descriptor block0Descriptor) {
        boolean bl;
        if (this.aDescriptors.size() < 4) {
            bl = this.aDescriptors.add(block0Descriptor);
            this.reSort();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean addDescriptorToLocation(Block0Descriptor block0Descriptor, int n) {
        if (this.aDescriptors.size() < 4) {
            this.aDescriptors.add(n, block0Descriptor);
            this.reSort();
            return true;
        }
        return false;
    }

    public int getNumDescriptors() {
        return this.aDescriptors.size();
    }

    public Block0Descriptor getDescriptor(int n) {
        if (n < this.aDescriptors.size()) {
            return this.aDescriptors.get(n);
        }
        return null;
    }

    public void clearDescriptors() {
        this.aDescriptors.clear();
        this.generateChecksum();
    }

    public boolean removeDescriptor(int n) {
        boolean bl = false;
        if (n >= this.aDescriptors.size() | n < 0) {
            bl = false;
        } else {
            this.aDescriptors.remove(n);
            bl = true;
        }
        this.aDescriptors.trimToSize();
        this.generateChecksum();
        return bl;
    }

    private int getDTDsChecksumValue() {
        int n = 0;
        int n2 = 0;
        String string = new String();
        for (n2 = 0; n2 < this.aDescriptors.size(); ++n2) {
            string = string + this.aDescriptors.get(n2).extractDescriptorData();
        }
        for (n2 = 0; n2 < string.length(); n2 += 2) {
            n += Integer.parseInt(string.substring(n2, n2 + 2), 16);
        }
        return n & 0xFF;
    }

    public void setExtensionFlag(int n) {
        this.iExtensionFlag = n;
    }

    public String getExtensionFlag() {
        return String.format("%02X", this.iExtensionFlag);
    }

    private int getExtensionFlagChecksum() {
        return this.iExtensionFlag & 0xFF;
    }

    public int generateChecksum() {
        int n = this.getHeaderChecksumValue();
        n += this.getProductIdentificationChecksumValue();
        n += this.getEDIDStructInfoChecksumValue();
        n += this.getBasicDisplayChecksumValue();
        n += this.getChromaticityChecksumValue();
        n += this.getEstablishedTimingsChecksumValue();
        n += this.getSTIsChecksumValue();
        n += this.getDTDsChecksumValue();
        n += this.getExtensionFlagChecksum();
        n &= 0xFF;
        this.block0_Checksum = n = 256 - n & 0xFF;
        return n;
    }

    public String getChecksum() {
        return String.format("%02X", this.block0_Checksum);
    }

    public void setChecksum(int n) {
        this.block0_Checksum = n;
    }

    private String getEstablishedTimings() {
        String string = String.format("%02X", this.getEstablishedTiming_One());
        string = string.concat(String.format("%02X", this.getEstablishedTiming_Two()));
        string = string.concat(String.format("%02X", this.getEstablishedTiming_Manufacturer()));
        return string;
    }

    private String getChromaticity() {
        int n = (int)Math.round(this.chromaticity_red_x * 1024.0);
        int n2 = n & 3;
        int n3 = n >> 2;
        int n4 = (int)Math.round(this.chromaticity_red_y * 1024.0);
        int n5 = n4 & 3;
        int n6 = n4 >> 2;
        int n7 = (int)Math.round(this.chromaticity_green_x * 1024.0);
        int n8 = n7 & 3;
        int n9 = n7 >> 2;
        int n10 = (int)Math.round(this.chromaticity_green_y * 1024.0);
        int n11 = n10 & 3;
        int n12 = n10 >> 2;
        int n13 = (int)Math.round(this.chromaticity_blue_x * 1024.0);
        int n14 = n13 & 3;
        int n15 = n13 >> 2;
        int n16 = (int)Math.round(this.chromaticity_blue_y * 1024.0);
        int n17 = n16 & 3;
        int n18 = n16 >> 2;
        int n19 = (int)Math.round(this.chromaticity_white_x * 1024.0);
        int n20 = n19 & 3;
        int n21 = n19 >> 2;
        int n22 = (int)Math.round(this.chromaticity_white_y * 1024.0);
        int n23 = n22 & 3;
        int n24 = n22 >> 2;
        int n25 = n2 << 6;
        n25 |= n5 << 4;
        n25 |= n8 << 2;
        int n26 = n14 << 6;
        n26 |= n17 << 4;
        n26 |= n20 << 2;
        String string = String.format("%02X", n25 |= n11);
        string = string.concat(String.format("%02X", n26 |= n23));
        string = string.concat(String.format("%02X", n3));
        string = string.concat(String.format("%02X", n6));
        string = string.concat(String.format("%02X", n9));
        string = string.concat(String.format("%02X", n12));
        string = string.concat(String.format("%02X", n15));
        string = string.concat(String.format("%02X", n18));
        string = string.concat(String.format("%02X", n21));
        string = string.concat(String.format("%02X", n24));
        return string;
    }

    private String convertToEISA() {
        int n = this.block0_ManufactureName[0] - 64;
        int n2 = this.block0_ManufactureName[1] - 64;
        int n3 = this.block0_ManufactureName[2] - 64;
        int n4 = 0;
        int n5 = 0;
        n4 |= n;
        n4 <<= 2;
        int n6 = n2 >> 3;
        int n7 = n2 & 7;
        n5 |= (n7 <<= 5);
        String string = new String();
        string = string.concat(String.format("%02X", n4 |= n6));
        string = string.concat(String.format("%02X", n5 |= n3));
        return string;
    }

    private String convertFromEISA(String string) {
        int n = Integer.parseInt(string.substring(0, 2), 16);
        int n2 = Integer.parseInt(string.substring(2, 4), 16);
        int n3 = n >> 2;
        int n4 = n3 + 64;
        int n5 = 3;
        n5 &= n;
        int n6 = n2 >> 5;
        int n7 = (n5 <<= 3) | n6;
        n7 += 64;
        int n8 = 31;
        int n9 = (n8 &= n2) + 64;
        char[] cArray = new char[3];
        cArray[0] = (char)n4;
        this.block0_ManufactureName[0] = cArray[0];
        cArray[1] = (char)n7;
        this.block0_ManufactureName[1] = cArray[1];
        cArray[2] = (char)n9;
        this.block0_ManufactureName[2] = cArray[2];
        return new String(cArray);
    }

    public String uploadData(String string) {
        String string2 = null;
        int n = string.substring(0, 16).toUpperCase().compareTo(this.getHeader());
        if (n != 0) {
            return "The incoming EDID does not have the right header.";
        }
        this.setManufacturerName(this.convertFromEISA(string.substring(16, 20)));
        this.setProductCode(string.substring(20, 24));
        this.setSerialNum(string.substring(24, 32));
        this.setWeekManufacture(Integer.parseInt(string.substring(32, 34), 16));
        this.setYearManufacture(1990 + Integer.parseInt(string.substring(34, 36), 16));
        if (Integer.parseInt(string.substring(36, 38), 16) != 1) {
            return "The version is invalid!!!";
        }
        if (Integer.parseInt(string.substring(38, 40), 16) != 3 && Integer.parseInt(string.substring(38, 40), 16) != 4) {
            return "The revision is invalid!!!";
        }
        this.setRevision(Integer.parseInt(string.substring(38, 40), 16));
        this.setVideoInputDefinition(string.substring(40, 42));
        this.setMaxHorizontalImage(Integer.parseInt(string.substring(42, 44), 16));
        this.setMaxVerticalImage(Integer.parseInt(string.substring(44, 46), 16));
        int n2 = Integer.parseInt(string.substring(46, 48), 16);
        double d = ((double)n2 + 100.0) / 100.0;
        this.setGamma(Double.toString(d));
        this.setFeatureSupport(string.substring(48, 50));
        this.setChromaticity(string.substring(50, 70));
        this.setEstablishedTiming_One(Integer.parseInt(string.substring(70, 72), 16));
        this.setEstablishedTiming_Two(Integer.parseInt(string.substring(72, 74), 16));
        this.setEstablishedTiming_Manufacturer(Integer.parseInt(string.substring(74, 76), 16));
        int n3 = 0;
        int n4 = 76;
        while (n3 < this.aSTI.size()) {
            this.aSTI.get(n3).uploadSTIData(string.substring(n4, n4 + 4));
            ++n3;
            n4 += 4;
        }
        Block0Descriptor block0Descriptor = null;
        n3 = 0;
        n4 = 108;
        boolean bl = false;
        boolean bl2 = false;
        while (n3 < 4) {
            int n5;
            block28: {
                block27: {
                    n5 = Integer.parseInt(string.substring(n4, n4 + 2), 16);
                    int n6 = Integer.parseInt(string.substring(n4 + 2, n4 + 4), 16);
                    if (n5 != 0 || n6 != 0) break block27;
                    n5 = Integer.parseInt(string.substring(n4 + 6, n4 + 8), 16);
                    switch (n5) {
                        case 255: {
                            block0Descriptor = new MonitorSerialNumber();
                            break;
                        }
                        case 254: {
                            block0Descriptor = new MonitorASCIIData();
                            break;
                        }
                        case 253: {
                            block0Descriptor = new MonitorRangeLimits();
                            if (this.getRevision() == 3) {
                                bl = true;
                                break;
                            }
                            break block28;
                        }
                        case 252: {
                            block0Descriptor = new MonitorName();
                            if (this.getRevision() == 3) {
                                bl2 = true;
                                break;
                            }
                            break block28;
                        }
                        case 251: {
                            if (this.getRevision() == 3) {
                                return "We do not support color point descriptors.";
                            }
                            if (this.getRevision() == 4) {
                                block0Descriptor = new ColorPointDescriptor();
                                break;
                            }
                            break block28;
                        }
                        case 250: {
                            block0Descriptor = new MonitorSTI();
                            break;
                        }
                        case 249: {
                            if (this.getRevision() == 4) {
                                block0Descriptor = new ColorManagementData();
                                break;
                            }
                        }
                        case 248: {
                            if (this.getRevision() == 4) {
                                block0Descriptor = new CVT3ByteCodeDescriptor();
                                break;
                            }
                        }
                        case 247: {
                            if (this.getRevision() == 4) {
                                block0Descriptor = new EstablishedTimingsIIIDescriptor();
                                break;
                            }
                        }
                        case 16: {
                            block0Descriptor = new DummyDescriptor();
                            break;
                        }
                        default: {
                            block0Descriptor = new MonitorManufacturer(n5);
                            break;
                        }
                    }
                    break block28;
                }
                block0Descriptor = new TimingDescriptor();
            }
            if (n5 == 250) {
                MonitorSTI monitorSTI = (MonitorSTI)block0Descriptor;
                monitorSTI.uploadDescriptorData(string.substring(n4 + 10, n4 + 36));
            } else {
                ((Block0Descriptor)block0Descriptor).uploadDescriptorData(string.substring(n4, n4 + 36));
            }
            this.addDescriptor(block0Descriptor);
            ++n3;
            n4 += 36;
        }
        if (this.getRevision() == 3 && !(bl & bl2)) {
            string2 = "Error uploading Block 0.  Missing Monitor Range or Monitor Name descriptors.";
        }
        this.setExtensionFlag(Integer.parseInt(string.substring(252, 254), 16));
        this.setChecksum(Integer.parseInt(string.substring(254, 256), 16));
        return string2;
    }

    public String extractBlockData() {
        String string = new String();
        int n = 0;
        string = string + this.getHeader();
        string = string + this.getProductIdentification();
        string = string + this.getEDIDStructInfo();
        string = string + this.getBasicDisplayInfo();
        string = string + this.getChromaticity();
        string = string + this.getEstablishedTimings();
        n = 0;
        while (n < this.aSTI.size()) {
            string = string + this.aSTI.get(n++).extractSTIData();
        }
        n = 0;
        while (n < this.aDescriptors.size()) {
            if (this.block0_Revision == 3 && !this.validateDescriptors()) {
                return "ERROR: Invalid number or types of descriptors\nThis EDID has " + this.aDescriptors.size() + " descriptors";
            }
            if (this.aDescriptors.size() < 4 & n == 1) {
                string = string + this.aDescriptors.get(0).extractDescriptorData();
            }
            string = string + this.aDescriptors.get(n++).extractDescriptorData();
        }
        string = string + String.format("%02X", Integer.parseInt(this.getExtensionFlag(), 10));
        this.generateChecksum();
        string = string + this.getChecksum();
        return string;
    }

    public boolean checkCanBeChangeTo(int n, boolean bl) {
        if (bl) {
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    if (this.aDescriptors.get(i).getDisplayName().equalsIgnoreCase("Timing Descriptor")) continue;
                    JOptionPane.showMessageDialog(null, "\"Timing Descriptors\" should procede other types of descriptors!\nPlease change previous blocks that are not \"Timing Descriptor\"!");
                    return false;
                }
            }
            return true;
        }
        if (n != 3) {
            for (int i = n + 1; i < 4; ++i) {
                if (!this.aDescriptors.get(i).getDisplayName().equalsIgnoreCase("Timing Descriptor")) continue;
                JOptionPane.showMessageDialog(null, "Timing Descriptors should procede other types of descriptors!\nPlease change the \"Timing Descriptor\" below to \"Monitor Descriptor\"!");
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabName {
        SCREEN_SIZE,
        ARL,
        ARP,
        UNDEFINED;

    }
}

